<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Newsletter extends Model
{
    /** @use HasFactory<\Database\Factories\NewsletterFactory> */
    use HasFactory;

    protected $fillable = [
        'user_id',
        'email',
        'is_subscribed',
        'subscribed_at',
        'unsubscribed_at',
    ];

    protected $casts = [
        'is_subscribed' => 'boolean',
        'subscribed_at' => 'datetime',
        'unsubscribed_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function scopeSubscribed($query)
    {
        return $query->where('is_subscribed', true);
    }

    public function scopeUnsubscribed($query)
    {
        return $query->where('is_subscribed', false);
    }

    public function scopeSubscribe($query, $email)
    {
        return $query->updateOrCreate(
            ['email' => $email],
            ['is_subscribed' => true, 'subscribed_at' => now()]
        );
    }

    public function scopeUnsubscribe($query, $email)
    {
        return $query->where('email', $email)->update(['is_subscribed' => false, 'unsubscribed_at' => now()]);
    }
}
